----------------------------------------------------------------------------------------------------
--Created on 2023/04/23 by JoyJ
--注意nMP和nHP现在是百分比数值了，意味着提升到了100倍
----------------------------------------------------------------------------------------------------
local X = {}
local bDebugMode = false
local bot = GetBot()

--推进所需的最低装备。装备总价超过这个数值才会开始跟团推进，否则就分散打钱。
bot.NeedTotalWorth = 5000

local J = require( GetScriptDirectory()..'/FunLib/jmz_func' )
local Minion = dofile( GetScriptDirectory()..'/FunLib/aba_minion' )
local sTalentList = J.Skill.GetTalentList( bot )
local sAbilityList = J.Skill.GetAbilityList( bot )
local sOutfitType = J.Item.GetOutfitType( bot )

local tTalentTreeList = {
						['t25'] = {10, 0},
						['t20'] = {10, 0},
						['t15'] = {10, 0},
						['t10'] = {10, 0},
}

local tAllAbilityBuildList = {
    {2,3,2,1,2,6,2,1,1,1,6,3,3,3,6},
}

local nAbilityBuildList = J.Skill.GetRandomBuild( tAllAbilityBuildList )

local nTalentBuildList = J.Skill.GetTalentBuild( tTalentTreeList )

local tOutFitList = {}

tOutFitList['outfit_priest'] = {

	"item_mage_outfit",
	"item_glimmer_cape",
	"item_rod_of_atos",
	"item_aghanims_shard",
	"item_holy_locket",
	"item_lotus_orb",
	"item_ultimate_scepter",
	"item_cyclone",
	"item_sheepstick",
	"item_wind_waker",
	"item_moon_shard",

}

tOutFitList['outfit_tank'] = {

	"item_priest_outfit",
	"item_urn_of_shadows",
	"item_mekansm",
	"item_glimmer_cape",
	"item_aghanims_shard",
	"item_holy_locket",
	"item_guardian_greaves",
	"item_spirit_vessel",
	"item_assault",
	"item_shivas_guard",
	"item_sheepstick", 
	"item_moon_shard",

}

tOutFitList['outfit_mid'] = tOutFitList['outfit_tank']

tOutFitList['outfit_carry'] = tOutFitList['outfit_tank']

tOutFitList['outfit_mage'] = tOutFitList['outfit_priest']

X['sBuyList'] = tOutFitList[sOutfitType]

X['sSellList'] = {
	"item_ultimate_scepter",
	"item_magic_wand",
}

if J.Role.IsPvNMode() or J.Role.IsAllShadow() then X['sBuyList'], X['sSellList'] = { 'PvN_mage' }, {} end

nAbilityBuildList, nTalentBuildList, X['sBuyList'], X['sSellList'] = J.SetUserHeroInit( nAbilityBuildList, nTalentBuildList, X['sBuyList'], X['sSellList'] )

X['sSkillList'] = J.Skill.GetSkillList( sAbilityList, nAbilityBuildList, sTalentList, nTalentBuildList )

X['bDeafaultAbility'] = true
X['bDeafaultItem'] = true

function X.MinionThink( hMinionUnit )

	if Minion.IsValidUnit( hMinionUnit ) then
		Minion.IllusionThink( hMinionUnit )
	end

end

local abilityQ = bot:GetAbilityByName( sAbilityList[1] )
local abilityW = bot:GetAbilityByName( sAbilityList[2] )
local abilityE = bot:GetAbilityByName( sAbilityList[3] )
local abilityD = bot:GetAbilityByName( sAbilityList[4] )
local abilityF = bot:GetAbilityByName( sAbilityList[5] )
local abilityR = bot:GetAbilityByName( sAbilityList[6] )

local desire, target, motive

local mp, hp, enemyHeroes, allyHeroes, botTarget, sMotive
local bonusRange = 0

function X.SkillsComplement()

	if J.CanNotUseAbility(bot) or bot:IsInvisible() then return end

	mp = bot:GetManaPercent()
	hp = bot:GetHealthPercent()
	botTarget = J.GetProperTarget( bot )
	enemyHeroes = bot:GetNearbyHeroes( 1600, true, BOT_MODE_NONE )
	allyHeroes = J.GetAlliesNearLoc( bot:GetLocation(), 1600 )

	bonusRange = J.GetBonusCastRange(bot)

	--无目标技能
	desire, motive = X.ConsiderR()
	if (desire > 0) then
		J.SetReportMotive( bDebugMode, motive )
		J.SetQueuePtToINT( bot, true )
		bot:ActionQueue_UseAbility(abilityR)
	end

	--目标技能
	desire, target, motive = X.ConsiderQ()
	if (desire > 0) then
		J.SetReportMotive( bDebugMode, motive )
		J.SetQueuePtToINT( bot, true )
		bot:ActionQueue_UseAbilityOnEntity(abilityQ, target)
	end

	--目标技能
	desire, target, motive = X.ConsiderW()
	if (desire > 0) then
		J.SetReportMotive( bDebugMode, motive )
		J.SetQueuePtToINT( bot, true )
		bot:ActionQueue_UseAbilityOnEntity(abilityW, target)
	end

	--对地施法
	desire, target, motive = X.ConsiderE()
	if (desire > 0) then
		J.SetReportMotive( bDebugMode, motive )
		J.SetQueuePtToINT( bot, true )
		bot:ActionQueue_UseAbilityOnLocation(abilityE, target)
	end

	--对地施法
	desire, target, motive = X.ConsiderD()
	if (desire > 0) then
		J.SetReportMotive( bDebugMode, motive )
		J.SetQueuePtToINT( bot, true )
		bot:ActionQueue_UseAbilityOnLocation(abilityD, target)
	end

	--对地施法
	desire, target, motive = X.ConsiderF()
	if (desire > 0) then
		J.SetReportMotive( bDebugMode, motive )
		J.SetQueuePtToINT( bot, true )
		bot:ActionQueue_UseAbilityOnLocation(abilityF, target)
	end

end

--对目标施法的模板
function X.ConsiderQ()

	local abl = abilityQ
	if not abl:IsFullyCastable() then return 0 end
	local aLv = abl:GetLevel()
	local castPoint = abl:GetCastPoint()
	local radius = abl:GetAOERadius()
	local damage = abl:GetAbilityDamage()

	--一般要修改这里
	local castRange = abl:GetCastRange() + bonusRange
	
	local validTargets = FilterTable(enemyHeroes, function(u)
		return J.CanCastOnNonMagicImmune(u) --魔免则删掉Non
			and bot:GetDistanceToUnit(u) <= castRange
	end)

	if false then return BOT_ACTION_DESIRE_NONE, validTargets[1], 'Q-测试' end

	return BOT_ACTION_DESIRE_NONE

end

--对地面施法的模板
function X.ConsiderE()

	local abl = abilityE
	if not abl:IsFullyCastable() then return 0 end
	local aLv = abl:GetLevel()
	local castPoint = abl:GetCastPoint()
	local radius = abl:GetAOERadius()
	local damage = abl:GetAbilityDamage()

	--一般要修改这里
	local castRange = abl:GetCastRange() + bonusRange
	
	local validTargets = FilterTable(enemyHeroes, function(u)
		return not u:IsMagicImmune()
			and bot:GetDistanceToUnit(u) <= castRange
	end)

	if false then return BOT_ACTION_DESIRE_NONE, validTargets[1]:GetLocation(), 'W-测试' end

	return BOT_ACTION_DESIRE_NONE

end

--无目标施法的模板
function X.ConsiderR()

	local abl = abilityR
	if not abl:IsFullyCastable() then return 0 end
	local aLv = abl:GetLevel()
	local castPoint = abl:GetCastPoint()
	local radius = abl:GetAOERadius()
	local damage = abl:GetAbilityDamage()

	--一般要修改这里
	local castRange = abl:GetCastRange() + bonusRange

	local validTargets = FilterTable(enemyHeroes, function(u)
		return not u:IsMagicImmune()
			and bot:GetDistanceToUnit(u) <= castRange
	end)

	if false then return BOT_ACTION_DESIRE_NONE, 'W-测试' end

	return BOT_ACTION_DESIRE_NONE

end


return X



